<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * External services.
 *
 * @package    block_xp
 * @copyright  2018 Frédéric Massart
 * @author     Frédéric Massart <fred@branchup.tech>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
    'block_xp_search_courses' => [
        'classname' => 'block_xp\external',
        'methodname' => 'search_courses',
        'description' => 'Search for courses',
        'type' => 'read',
        'ajax' => true
    ],
    'block_xp_search_modules' => [
        'classname' => 'block_xp\external',
        'methodname' => 'search_modules',
        'description' => 'Search modules within a course',
        'type' => 'read',
        'ajax' => true
    ],
    'block_xp_set_default_levels_info' => [
        'classname' => 'block_xp\external',
        'methodname' => 'set_default_levels_info',
        'description' => 'Set the default levels info',
        'type' => 'write',
        'ajax' => true,
    ],
    'block_xp_set_levels_info' => [
        'classname' => 'block_xp\external',
        'methodname' => 'set_levels_info',
        'description' => 'Set the levels info',
        'type' => 'write',
        'ajax' => true,
    ],
];
